// ============================================
// "Thirsting for Home" by Maarten Dinger, 2005
// ============================================

#include "functions.inc"
#include "metals.inc"
#include "glass.inc"
#include "DrinkingBird.inc"

#declare use_photons=1;

global_settings{ 
  ambient_light 0.7
  assumed_gamma 1.8
  radiosity{ pretrace_start 0.08 pretrace_end 0.02 count 50 nearest_count 5 low_error_factor 0.01 error_bound 0.25 gray_threshold 0.5 recursion_limit 1 brightness 0.90 normal on}
  #if (use_photons)
     photons{ spacing .0025 autostop 0 }
  #end
  max_trace_level 64
}

#declare xrot = 0;
#declare yrot = 120;
#declare zrot = 0;
#declare xtrans = 0.7;
#declare ytrans = 0.5;
#declare ztrans = 1.5;
#declare effect_location = <-370,480,-1500>;
#declare camera_location = < 0, 0, 4> ;
#declare camera_look_at = <0,0,0>;

camera 
{
	direction < 0, 0, 1.072253>
	location camera_location
	up < 0, 1, 0>
	right < -1.33, 0, 0>
	look_at camera_look_at
}

light_source {effect_location color rgb < 1,1,1.05 >*4 area_light <50, 0, 0>, <0, 50, 0>, 3, 3 adaptive 1 jitter}
light_source {<-1.2,0.5,2.3> color rgb < 1.1,1,1 >*2 shadowless media_interaction off}

// Ground Level
sphere {0, 1.2760 
        pigment { image_map {jpeg "Images/Earth-Color4096-flip.jpg" map_type 1 interpolate 2 } }
        finish { ambient 0 diffuse 1 specular 0 } 
        normal { bump_map {jpeg "Images/Earth-Topo4096-flip.jpg" map_type 1 interpolate 2 bump_size 2} }
        rotate <xrot,yrot,zrot> translate <xtrans,ytrans,ztrans>}     
        
// Sea Level
sphere {0, 1.27601 
        pigment { image_map {gif "Images/Earth-Mask4096-flip.gif" map_type 1 interpolate 2 transmit 0,1} }
        finish { ambient 0 diffuse 1 specular 0.3 roughness 0.1 } 
        normal { waves 0.4 turbulence 0.5 scale 0.05 }
        rotate <xrot,yrot,zrot> translate <xtrans,ytrans,ztrans>}     

// Cloud Level    
sphere {0, 1.2780 
        pigment {image_map {gif "Images/Earth-Clouds2700-flip-2.gif" map_type 1 interpolate 2 
        #declare n=0;
        #while (n<220)
        transmit n,1-(n/232)
        #declare n=n+1;
        #end } }
        finish { ambient 0 diffuse 1 specular 0 } 
        normal {granite 0.12 scale 0.07 } 
        rotate <xrot,yrot,zrot> translate <xtrans,ytrans,ztrans>}                     

//Atmosphere Level
sphere {0, 1.3100 hollow
        pigment { rgbt 1 }
        interior { media { scattering { 1, <0.1,0.4,1> } 
        samples 1,10 } }
        translate <xtrans,ytrans,ztrans>}

// Isosurface Rock
#declare fn_Pigm=function { pigment { granite color_map { [0 color rgb 0] [1 color rgb 1] } } }
                     
isosurface {
  function { f_sphere(x/2+0.3,y*1.5,z,1.2) + f_noise3d(x*10, y*10, z*10)*0.05 + fn_Pigm(x/3, 0, z/3).gray*0.2}
        max_gradient 5
        contained_by{sphere{0,2}} open
        pigment {rgb <0.45,0.4,0.32>*0.5}
        finish {ambient -0.5 phong 0.5 phong_size 10}
        rotate <35,60,10> translate <-0.7,-1.43,7.6> scale 0.4}


// Drinking Bird
#declare BlueLiquid=
  material{
   texture{
    pigment{color rgbf <0,0,1,0.95> }
    normal{ripples 0.2 scale 0.2}
    finish{ ambient 1 reflection{.1,1 fresnel} conserve_energy}
   }
   interior { ior 1.3 media { scattering { 2 <0.5, 0.65, 0.4> extinction 1 } } }
}

#declare m_glass=
material{
 texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 1> }
    finish { F_Glass7 }   
    }
    interior{ ior 1.4 } 
} 

union {
object {DB_Glass material {m_glass} #if (use_photons) photons { target refraction on reflection on collect off } #end }
object {DB_Head texture { pigment { color rgb < 1 0 0 >} finish { ambient 0.4 specular 0.5 roughness 0.05} } }
object {DB_Hat texture { pigment { color rgb < 0 0 1 >} finish { ambient 0.4 specular 0.5 roughness 0.05} } }
object {DB_EyeWhite texture { pigment { color rgb < 1 1 1 >} finish { ambient 0.55 specular 0.5 roughness 0.05} } } 
object {DB_EyeBlack texture { pigment { color rgb < 0 0 0 >} finish { ambient 0.4 specular 0.5 roughness 0.05} } } 
object {DB_Hinge texture { T_Chrome_3D } }      
object {DB_Feet texture { pigment { color rgb < 1 0 0 >} finish { ambient 0.4 specular 0.5 roughness 0.05} } }
object {DB_Legs texture { pigment { color rgb < 1 1 1 >} finish { ambient 0.55 specular 0.5 roughness 0.05} } }
object {DB_BlueLiquid material {BlueLiquid} #if (use_photons) photons { target refraction on reflection on collect off } #end }
scale 0.18
rotate <0,-20,-2>
translate <-0.40,-0.3,3.1>
} 

// Lens Flare                                  
   #declare source_colour = < 2.05, 2.05, 2>*1;
   #declare glow_type = 4;
   #declare glow_colour = <1.03, 1.03, 1>*0.6;
   #declare rays_type = 1;
   #declare rays_colour = <1.03, 1.03, 1>;
   #declare rays_scale = <1, 1, 1>*0.6 ;
   #declare rays_intensity = 6;
   #declare rays_seed = 4;
   #declare streak_type = 7;
   #declare streak_colour = <1.03, 1.03, 1>*1;
   #declare streak_scale = <1, 1, 1>*0.65;
   #declare streak_intensity = 7;
   #declare streak_to_centre = true;
   #declare spots_type = 5;
   #declare spots_colour = <1.03, 1.03, 1>;
   #declare spots_scale = <1, 1, 1>*0.5;
   #declare spots_intensity = 2;
   #declare spots_seed = 8;
   #declare _LE_created = true; 
   #include "LnsEfcts.inc"